clearvars
close all

iseed = 0;
repvals = [10,10];
markers = {'kx','rx'};
logt = 4;
lognc = 5;
dt = 10;
Lvals = [20,50];
formatSpec = '%f';

sLLarr=linspace(0,50,11);

for i=1:size(Lvals,2)
L=Lvals(i);
repeats=repvals(i);
dpqval=zeros(repeats,11);
for sval=0:10

for seed=iseed:iseed+repeats-1

sLL=sval*5;
meas = 'dpq';
FILENAME = sprintf('%d%sAve1e,%d,%d,%d,%d,%d.txt',seed,meas,logt,L,lognc,sLL,dt);
fileID = fopen(FILENAME,'r');

meas='|dpq|^2';

A=fscanf(fileID,formatSpec); %Read in data file (dpq^2)
dpqval(seed+1,sval+1)=A(8)/sqrt(L); %Read in dpq at t=5000

end
end

hold on, errorbar(sLLarr, mean(dpqval,1), std(dpqval,1)/sqrt(repeats), markers{i},'MarkerSize',10,'LineWidth',2);
end

hold on, plot([20,20],[0,30],'k--','LineWidth',2.4);

xlim([0,50]);
ylim([0,30]);

box off;
set(gca, 'FontSize', 25);
set(gca,'linewidth',2);
xlabel('$\lambda$','interpreter','latex');
ylabel('$\langle|\delta \rho_1|^2\rangle_s$','interpreter','latex');
set(gca,'YTick', [0, 10, 20, 30]);
set(gca,'XTick', [0,25,50]);

hold on, plot(3,24,'kx','MarkerSize',12,'LineWidth',2);
text(6,24,'$L=20$','FontSize',20,'interpreter','latex');
hold on, plot(3,20,'rx','MarkerSize',12,'LineWidth',2);
text(6,20,'$L=50$','FontSize',20,'interpreter','latex');
hold on, plot([1.7,5.7],[16,16],'k--','LineWidth',2.4);
text(6.4,16.3,'Phase','FontSize',16);
text(2,13.3,'Transition','FontSize',16);

plotname = sprintf('dpqGraph.png');
saveas(gcf,plotname);